<?php 
include 'header2.php'; 
include 'koneksi.php';

// Ambil data bobot dari tabel bobot2
$bobot = query("SELECT * FROM bobot2");

// Ambil data alternatif dari tabel input_nilai2
$alternatif = query("SELECT * FROM channel");

// Definisi Nama Kriteria
$kriteria_nama = [
    "c1" => "Jumlah Views",
    "c2" => "Jumlah Subscribers",
    "c3" => "Frekuensi Unggah Video",
    "c4" => "Jumlah Video Diunggah",
    "c5" => "Latar Belakang Pengajar / Konten Kreator"
];

?>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-4">
            <h2 class="text-center mb-4 py-3 bg-light rounded" style="font-size: 28;" ><strong>DATA BOBOT KRITERIA DAN NILAI ALTERNATIF</strong></h2>

            <!-- **Tabel Bobot Kriteria** -->
            <div class="card shadow-sm w-100">
                <div class="card-header bg-success text-white text-center align-middle">
                    <h4><i class="fas fa-balance-scale"></i> Kriteria dan Bobot</h4>
                </div>
                <div class="card-body">
                    <?php if (!empty($bobot)) : ?>
                        <div class="table-responsive">
                            <table class="table table-bordered text-center w-100">
                                <thead class="table-primary"> <!-- Biru tua -->
                                    <tr>
                                        <th>Kode Kriteria</th>
                                        <th>Nama Kriteria</th>
                                        <th>Bobot</th>
                                    </tr>
                                </thead>
                                <tbody class="table-light">
                                    <?php foreach ($bobot[0] as $key => $value) : ?>
                                        <?php if (isset($kriteria_nama[$key])) : ?>
                                            <tr>
                                                <td class="align-middle"><?= strtoupper($key); ?></td>
                                                <td class="align-middle"><?= $kriteria_nama[$key]; ?></td>
                                                <td class="align-middle"><?= $value; ?></td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else : ?>
                        <div class="alert alert-danger text-center">Data tidak tersedia!</div>
                    <?php endif; ?>
                </div>
            </div>

            <br>

            <!-- **Tabel Data Alternatif** -->
            <div class="card shadow-sm w-100 mt-4">
                <div class="card-header bg-success text-white text-center align-middle">
                    <h4><i class="fas fa-table"></i> Nilai Alternatif</h4>
                </div>
                <div class="card-body">
                    <?php if (!empty($alternatif)) : ?>
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover w-100">
                                <thead class="table-success text-center">
                                    <tr>
                                        <th style="width: 5%;">No.</th>
                                        <th style="width: 20%;">Nama Channel</th>
                                        <th>C1</th>
                                        <th>C2</th>
                                        <th>C3</th>
                                        <th>C4</th>
                                        <th>C5</th>
                                    </tr>
                                </thead>
                                <tbody class="table-light text-center">
                                    <?php $no = 1; ?>
                                    <?php foreach ($alternatif as $row) : ?>
                                        <tr>
                                            <td class="align-middle"><?= $no++; ?></td>
                                            <td class="align-middle"><?= htmlspecialchars($row["nama"]); ?></td>
                                            <td class="align-middle"><?= $row["c1"]; ?></td>
                                            <td class="align-middle"><?= $row["c2"]; ?></td>
                                            <td class="align-middle"><?= $row["c3"]; ?></td>
                                            <td class="align-middle"><?= $row["c4"]; ?></td>
                                            <td class="align-middle"><?= $row["c5"]; ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php else : ?>
                        <div class="alert alert-danger text-center">Data alternatif tidak tersedia!</div>
                    <?php endif; ?>
                </div>

                <!-- **Tombol Mulai Proses Perhitungan** -->
                <br><br>
                <div class="text-center">
                    <a href="proses2.php" class="btn btn-lg btn-outline-success">
                        <i class="fas fa-calculator"></i> Mulai Proses Perhitungan
                    </a>
                </div>
    
        <br><br>
            </div> <!-- Akhir dari card -->
        </div>
    </main>
</div>

<!-- 🔥 Pastikan navigasi bisa dibuka dan tidak macet -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let sidebarToggle = document.querySelector("#sidebarToggle");
        if (sidebarToggle) {
            sidebarToggle.addEventListener("click", function (e) {
                e.preventDefault();
                document.body.classList.toggle("sb-sidenav-toggled");
            });
        }
    });
</script>
